package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{Timestamp, CustomerAccountId}
import scala.jdk.CollectionConverters._
final case class GetRegisterAccountStatusResponse(
    customerAccountId: CustomerAccountId,
    accountStatus: zio.aws.iotfleetwise.model.RegistrationStatus,
    timestreamRegistrationResponse: Optional[
      zio.aws.iotfleetwise.model.TimestreamRegistrationResponse
    ] = Optional.Absent,
    iamRegistrationResponse: zio.aws.iotfleetwise.model.IamRegistrationResponse,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse = {
    import GetRegisterAccountStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse
      .builder()
      .customerAccountId(
        CustomerAccountId.unwrap(customerAccountId): java.lang.String
      )
      .accountStatus(accountStatus.unwrap)
      .optionallyWith(
        timestreamRegistrationResponse.map(value => value.buildAwsValue())
      )(_.timestreamRegistrationResponse)
      .iamRegistrationResponse(iamRegistrationResponse.buildAwsValue())
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse
      .wrap(buildAwsValue())
}
object GetRegisterAccountStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse =
      zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse(
        customerAccountId,
        accountStatus,
        timestreamRegistrationResponse.map(value => value.asEditable),
        iamRegistrationResponse.asEditable,
        creationTime,
        lastModificationTime
      )
    def customerAccountId: CustomerAccountId
    def accountStatus: zio.aws.iotfleetwise.model.RegistrationStatus
    def timestreamRegistrationResponse: Optional[
      zio.aws.iotfleetwise.model.TimestreamRegistrationResponse.ReadOnly
    ]
    def iamRegistrationResponse
        : zio.aws.iotfleetwise.model.IamRegistrationResponse.ReadOnly
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getCustomerAccountId: ZIO[Any, Nothing, CustomerAccountId] =
      ZIO.succeed(customerAccountId)
    def getAccountStatus
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.RegistrationStatus] =
      ZIO.succeed(accountStatus)
    def getTimestreamRegistrationResponse: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.TimestreamRegistrationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timestreamRegistrationResponse",
      timestreamRegistrationResponse
    )
    def getIamRegistrationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.iotfleetwise.model.IamRegistrationResponse.ReadOnly
    ] = ZIO.succeed(iamRegistrationResponse)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse
  ) extends zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly {
    override val customerAccountId: CustomerAccountId =
      zio.aws.iotfleetwise.model.primitives
        .CustomerAccountId(impl.customerAccountId())
    override val accountStatus: zio.aws.iotfleetwise.model.RegistrationStatus =
      zio.aws.iotfleetwise.model.RegistrationStatus.wrap(impl.accountStatus())
    override val timestreamRegistrationResponse: Optional[
      zio.aws.iotfleetwise.model.TimestreamRegistrationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timestreamRegistrationResponse())
      .map(value =>
        zio.aws.iotfleetwise.model.TimestreamRegistrationResponse.wrap(value)
      )
    override val iamRegistrationResponse
        : zio.aws.iotfleetwise.model.IamRegistrationResponse.ReadOnly =
      zio.aws.iotfleetwise.model.IamRegistrationResponse
        .wrap(impl.iamRegistrationResponse())
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusResponse
  ): zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly =
    new Wrapper(impl)
}
