package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  Uint32,
  MaxSampleCount,
  WildcardSignalName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SignalInformation(
    name: WildcardSignalName,
    maxSampleCount: Optional[MaxSampleCount] = Optional.Absent,
    minimumSamplingIntervalMs: Optional[Uint32] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.SignalInformation = {
    import SignalInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.SignalInformation
      .builder()
      .name(WildcardSignalName.unwrap(name): java.lang.String)
      .optionallyWith(
        maxSampleCount.map(value =>
          MaxSampleCount.unwrap(value): java.lang.Long
        )
      )(_.maxSampleCount)
      .optionallyWith(
        minimumSamplingIntervalMs.map(value =>
          Uint32.unwrap(value): java.lang.Long
        )
      )(_.minimumSamplingIntervalMs)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.SignalInformation.ReadOnly =
    zio.aws.iotfleetwise.model.SignalInformation.wrap(buildAwsValue())
}
object SignalInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.SignalInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.SignalInformation =
      zio.aws.iotfleetwise.model.SignalInformation(
        name,
        maxSampleCount.map(value => value),
        minimumSamplingIntervalMs.map(value => value)
      )
    def name: WildcardSignalName
    def maxSampleCount: Optional[MaxSampleCount]
    def minimumSamplingIntervalMs: Optional[Uint32]
    def getName: ZIO[Any, Nothing, WildcardSignalName] = ZIO.succeed(name)
    def getMaxSampleCount: ZIO[Any, AwsError, MaxSampleCount] =
      AwsError.unwrapOptionField("maxSampleCount", maxSampleCount)
    def getMinimumSamplingIntervalMs: ZIO[Any, AwsError, Uint32] = AwsError
      .unwrapOptionField("minimumSamplingIntervalMs", minimumSamplingIntervalMs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.SignalInformation
  ) extends zio.aws.iotfleetwise.model.SignalInformation.ReadOnly {
    override val name: WildcardSignalName =
      zio.aws.iotfleetwise.model.primitives.WildcardSignalName(impl.name())
    override val maxSampleCount: Optional[MaxSampleCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSampleCount())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.MaxSampleCount(value)
        )
    override val minimumSamplingIntervalMs: Optional[Uint32] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumSamplingIntervalMs())
        .map(value => zio.aws.iotfleetwise.model.primitives.Uint32(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.SignalInformation
  ): zio.aws.iotfleetwise.model.SignalInformation.ReadOnly = new Wrapper(impl)
}
