package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Branch(
    fullyQualifiedName: String,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.Branch = {
    import Branch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.Branch
      .builder()
      .fullyQualifiedName(fullyQualifiedName: java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.Branch.ReadOnly =
    zio.aws.iotfleetwise.model.Branch.wrap(buildAwsValue())
}
object Branch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.Branch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.Branch =
      zio.aws.iotfleetwise.model
        .Branch(fullyQualifiedName, description.map(value => value))
    def fullyQualifiedName: String
    def description: Optional[Description]
    def getFullyQualifiedName: ZIO[Any, Nothing, String] =
      ZIO.succeed(fullyQualifiedName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Branch
  ) extends zio.aws.iotfleetwise.model.Branch.ReadOnly {
    override val fullyQualifiedName: String = impl.fullyQualifiedName(): String
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Branch
  ): zio.aws.iotfleetwise.model.Branch.ReadOnly = new Wrapper(impl)
}
