package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterAccountRequest(
    timestreamResources: zio.aws.iotfleetwise.model.TimestreamResources,
    iamResources: Optional[zio.aws.iotfleetwise.model.IamResources] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest = {
    import RegisterAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest
      .builder()
      .timestreamResources(timestreamResources.buildAwsValue())
      .optionallyWith(iamResources.map(value => value.buildAwsValue()))(
        _.iamResources
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.RegisterAccountRequest.ReadOnly =
    zio.aws.iotfleetwise.model.RegisterAccountRequest.wrap(buildAwsValue())
}
object RegisterAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.RegisterAccountRequest =
      zio.aws.iotfleetwise.model.RegisterAccountRequest(
        timestreamResources.asEditable,
        iamResources.map(value => value.asEditable)
      )
    def timestreamResources
        : zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly
    def iamResources: Optional[zio.aws.iotfleetwise.model.IamResources.ReadOnly]
    def getTimestreamResources: ZIO[
      Any,
      Nothing,
      zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly
    ] = ZIO.succeed(timestreamResources)
    def getIamResources
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.IamResources.ReadOnly] =
      AwsError.unwrapOptionField("iamResources", iamResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest
  ) extends zio.aws.iotfleetwise.model.RegisterAccountRequest.ReadOnly {
    override val timestreamResources
        : zio.aws.iotfleetwise.model.TimestreamResources.ReadOnly =
      zio.aws.iotfleetwise.model.TimestreamResources
        .wrap(impl.timestreamResources())
    override val iamResources
        : Optional[zio.aws.iotfleetwise.model.IamResources.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamResources())
        .map(value => zio.aws.iotfleetwise.model.IamResources.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest
  ): zio.aws.iotfleetwise.model.RegisterAccountRequest.ReadOnly = new Wrapper(
    impl
  )
}
