package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait Compression {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.Compression
}
object Compression {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.Compression
  ): zio.aws.iotfleetwise.model.Compression = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.Compression.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.Compression.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.iotfleetwise.model.Compression.SNAPPY =>
      val r = SNAPPY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.Compression {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.Compression =
      software.amazon.awssdk.services.iotfleetwise.model.Compression.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.iotfleetwise.model.Compression {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.Compression =
      software.amazon.awssdk.services.iotfleetwise.model.Compression.OFF
  }
  case object SNAPPY extends zio.aws.iotfleetwise.model.Compression {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.Compression =
      software.amazon.awssdk.services.iotfleetwise.model.Compression.SNAPPY
  }
}
