package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateDecoderManifestResponse(name: ResourceName, arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse = {
    import UpdateDecoderManifestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse
      .wrap(buildAwsValue())
}
object UpdateDecoderManifestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse =
      zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse(name, arn)
    def name: ResourceName
    def arn: Arn
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse
  ) extends zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestResponse
  ): zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly =
    new Wrapper(impl)
}
