package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{Timestamp, Arn}
import scala.jdk.CollectionConverters._
final case class SignalCatalogSummary(
    name: Optional[String] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.SignalCatalogSummary = {
    import SignalCatalogSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.SignalCatalogSummary
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly =
    zio.aws.iotfleetwise.model.SignalCatalogSummary.wrap(buildAwsValue())
}
object SignalCatalogSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.SignalCatalogSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.SignalCatalogSummary =
      zio.aws.iotfleetwise.model.SignalCatalogSummary(
        name.map(value => value),
        arn.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def name: Optional[String]
    def arn: Optional[Arn]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.SignalCatalogSummary
  ) extends zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.SignalCatalogSummary
  ): zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly = new Wrapper(
    impl
  )
}
