package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  ListVehiclesMaxResults,
  NextToken,
  Arn
}
import scala.jdk.CollectionConverters._
final case class ListVehiclesRequest(
    modelManifestArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListVehiclesMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest = {
    import ListVehiclesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest
      .builder()
      .optionallyWith(
        modelManifestArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.modelManifestArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListVehiclesMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.ListVehiclesRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ListVehiclesRequest.wrap(buildAwsValue())
}
object ListVehiclesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListVehiclesRequest =
      zio.aws.iotfleetwise.model.ListVehiclesRequest(
        modelManifestArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def modelManifestArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListVehiclesMaxResults]
    def getModelManifestArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("modelManifestArn", modelManifestArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListVehiclesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest
  ) extends zio.aws.iotfleetwise.model.ListVehiclesRequest.ReadOnly {
    override val modelManifestArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelManifestArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
    override val maxResults: Optional[ListVehiclesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.ListVehiclesMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest
  ): zio.aws.iotfleetwise.model.ListVehiclesRequest.ReadOnly = new Wrapper(impl)
}
