package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDecoderManifestsResponse(
    summaries: Optional[
      Iterable[zio.aws.iotfleetwise.model.DecoderManifestSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse = {
    import ListDecoderManifestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListDecoderManifestsResponse
      .wrap(buildAwsValue())
}
object ListDecoderManifestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListDecoderManifestsResponse =
      zio.aws.iotfleetwise.model.ListDecoderManifestsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Optional[
      List[zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse
  ) extends zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly {
    override val summaries: Optional[
      List[zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.DecoderManifestSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsResponse
  ): zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly =
    new Wrapper(impl)
}
