package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, CampaignName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCampaignResponse(
    name: Optional[CampaignName] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse = {
    import CreateCampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse
      .builder()
      .optionallyWith(
        name.map(value => CampaignName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly =
    zio.aws.iotfleetwise.model.CreateCampaignResponse.wrap(buildAwsValue())
}
object CreateCampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateCampaignResponse =
      zio.aws.iotfleetwise.model.CreateCampaignResponse(
        name.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[CampaignName]
    def arn: Optional[Arn]
    def getName: ZIO[Any, AwsError, CampaignName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse
  ) extends zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly {
    override val name: Optional[CampaignName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotfleetwise.model.primitives.CampaignName(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignResponse
  ): zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly = new Wrapper(
    impl
  )
}
