package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  LanguageVersion,
  Uint32,
  EventExpression
}
import scala.jdk.CollectionConverters._
final case class ConditionBasedCollectionScheme(
    expression: EventExpression,
    minimumTriggerIntervalMs: Optional[Uint32] = Optional.Absent,
    triggerMode: Optional[zio.aws.iotfleetwise.model.TriggerMode] =
      Optional.Absent,
    conditionLanguageVersion: Optional[LanguageVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ConditionBasedCollectionScheme = {
    import ConditionBasedCollectionScheme.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ConditionBasedCollectionScheme
      .builder()
      .expression(EventExpression.unwrap(expression): java.lang.String)
      .optionallyWith(
        minimumTriggerIntervalMs.map(value =>
          Uint32.unwrap(value): java.lang.Long
        )
      )(_.minimumTriggerIntervalMs)
      .optionallyWith(triggerMode.map(value => value.unwrap))(_.triggerMode)
      .optionallyWith(
        conditionLanguageVersion.map(value =>
          LanguageVersion.unwrap(value): Integer
        )
      )(_.conditionLanguageVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme.ReadOnly =
    zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme
      .wrap(buildAwsValue())
}
object ConditionBasedCollectionScheme {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ConditionBasedCollectionScheme
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme =
      zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme(
        expression,
        minimumTriggerIntervalMs.map(value => value),
        triggerMode.map(value => value),
        conditionLanguageVersion.map(value => value)
      )
    def expression: EventExpression
    def minimumTriggerIntervalMs: Optional[Uint32]
    def triggerMode: Optional[zio.aws.iotfleetwise.model.TriggerMode]
    def conditionLanguageVersion: Optional[LanguageVersion]
    def getExpression: ZIO[Any, Nothing, EventExpression] =
      ZIO.succeed(expression)
    def getMinimumTriggerIntervalMs: ZIO[Any, AwsError, Uint32] = AwsError
      .unwrapOptionField("minimumTriggerIntervalMs", minimumTriggerIntervalMs)
    def getTriggerMode
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.TriggerMode] =
      AwsError.unwrapOptionField("triggerMode", triggerMode)
    def getConditionLanguageVersion: ZIO[Any, AwsError, LanguageVersion] =
      AwsError.unwrapOptionField(
        "conditionLanguageVersion",
        conditionLanguageVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ConditionBasedCollectionScheme
  ) extends zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme.ReadOnly {
    override val expression: EventExpression =
      zio.aws.iotfleetwise.model.primitives.EventExpression(impl.expression())
    override val minimumTriggerIntervalMs: Optional[Uint32] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumTriggerIntervalMs())
        .map(value => zio.aws.iotfleetwise.model.primitives.Uint32(value))
    override val triggerMode: Optional[zio.aws.iotfleetwise.model.TriggerMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggerMode())
        .map(value => zio.aws.iotfleetwise.model.TriggerMode.wrap(value))
    override val conditionLanguageVersion: Optional[LanguageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionLanguageVersion())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.LanguageVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ConditionBasedCollectionScheme
  ): zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme.ReadOnly =
    new Wrapper(impl)
}
