package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  ErrorMessage,
  Arn,
  TimestreamTableName,
  TimestreamDatabaseName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TimestreamRegistrationResponse(
    timestreamDatabaseName: TimestreamDatabaseName,
    timestreamTableName: TimestreamTableName,
    timestreamDatabaseArn: Optional[Arn] = Optional.Absent,
    timestreamTableArn: Optional[Arn] = Optional.Absent,
    registrationStatus: zio.aws.iotfleetwise.model.RegistrationStatus,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.TimestreamRegistrationResponse = {
    import TimestreamRegistrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.TimestreamRegistrationResponse
      .builder()
      .timestreamDatabaseName(
        TimestreamDatabaseName.unwrap(timestreamDatabaseName): java.lang.String
      )
      .timestreamTableName(
        TimestreamTableName.unwrap(timestreamTableName): java.lang.String
      )
      .optionallyWith(
        timestreamDatabaseArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.timestreamDatabaseArn)
      .optionallyWith(
        timestreamTableArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.timestreamTableArn)
      .registrationStatus(registrationStatus.unwrap)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.TimestreamRegistrationResponse.ReadOnly =
    zio.aws.iotfleetwise.model.TimestreamRegistrationResponse
      .wrap(buildAwsValue())
}
object TimestreamRegistrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.TimestreamRegistrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.TimestreamRegistrationResponse =
      zio.aws.iotfleetwise.model.TimestreamRegistrationResponse(
        timestreamDatabaseName,
        timestreamTableName,
        timestreamDatabaseArn.map(value => value),
        timestreamTableArn.map(value => value),
        registrationStatus,
        errorMessage.map(value => value)
      )
    def timestreamDatabaseName: TimestreamDatabaseName
    def timestreamTableName: TimestreamTableName
    def timestreamDatabaseArn: Optional[Arn]
    def timestreamTableArn: Optional[Arn]
    def registrationStatus: zio.aws.iotfleetwise.model.RegistrationStatus
    def errorMessage: Optional[ErrorMessage]
    def getTimestreamDatabaseName: ZIO[Any, Nothing, TimestreamDatabaseName] =
      ZIO.succeed(timestreamDatabaseName)
    def getTimestreamTableName: ZIO[Any, Nothing, TimestreamTableName] =
      ZIO.succeed(timestreamTableName)
    def getTimestreamDatabaseArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("timestreamDatabaseArn", timestreamDatabaseArn)
    def getTimestreamTableArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("timestreamTableArn", timestreamTableArn)
    def getRegistrationStatus
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.RegistrationStatus] =
      ZIO.succeed(registrationStatus)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimestreamRegistrationResponse
  ) extends zio.aws.iotfleetwise.model.TimestreamRegistrationResponse.ReadOnly {
    override val timestreamDatabaseName: TimestreamDatabaseName =
      zio.aws.iotfleetwise.model.primitives
        .TimestreamDatabaseName(impl.timestreamDatabaseName())
    override val timestreamTableName: TimestreamTableName =
      zio.aws.iotfleetwise.model.primitives
        .TimestreamTableName(impl.timestreamTableName())
    override val timestreamDatabaseArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.timestreamDatabaseArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val timestreamTableArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.timestreamTableArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val registrationStatus
        : zio.aws.iotfleetwise.model.RegistrationStatus =
      zio.aws.iotfleetwise.model.RegistrationStatus
        .wrap(impl.registrationStatus())
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.iotfleetwise.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.TimestreamRegistrationResponse
  ): zio.aws.iotfleetwise.model.TimestreamRegistrationResponse.ReadOnly =
    new Wrapper(impl)
}
