package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutEncryptionConfigurationResponse(
    kmsKeyId: Optional[String] = Optional.Absent,
    encryptionStatus: zio.aws.iotfleetwise.model.EncryptionStatus,
    encryptionType: zio.aws.iotfleetwise.model.EncryptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse = {
    import PutEncryptionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .encryptionStatus(encryptionStatus.unwrap)
      .encryptionType(encryptionType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse.ReadOnly =
    zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse
      .wrap(buildAwsValue())
}
object PutEncryptionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse =
      zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse(
        kmsKeyId.map(value => value),
        encryptionStatus,
        encryptionType
      )
    def kmsKeyId: Optional[String]
    def encryptionStatus: zio.aws.iotfleetwise.model.EncryptionStatus
    def encryptionType: zio.aws.iotfleetwise.model.EncryptionType
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncryptionStatus
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.EncryptionStatus] =
      ZIO.succeed(encryptionStatus)
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.EncryptionType] =
      ZIO.succeed(encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse
  ) extends zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val encryptionStatus: zio.aws.iotfleetwise.model.EncryptionStatus =
      zio.aws.iotfleetwise.model.EncryptionStatus.wrap(impl.encryptionStatus())
    override val encryptionType: zio.aws.iotfleetwise.model.EncryptionType =
      zio.aws.iotfleetwise.model.EncryptionType.wrap(impl.encryptionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.PutEncryptionConfigurationResponse
  ): zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
