package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.VehicleName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VehicleStatus(
    campaignName: Optional[String] = Optional.Absent,
    vehicleName: Optional[VehicleName] = Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.VehicleState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus = {
    import VehicleStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus
      .builder()
      .optionallyWith(campaignName.map(value => value: java.lang.String))(
        _.campaignName
      )
      .optionallyWith(
        vehicleName.map(value => VehicleName.unwrap(value): java.lang.String)
      )(_.vehicleName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly =
    zio.aws.iotfleetwise.model.VehicleStatus.wrap(buildAwsValue())
}
object VehicleStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.VehicleStatus =
      zio.aws.iotfleetwise.model.VehicleStatus(
        campaignName.map(value => value),
        vehicleName.map(value => value),
        status.map(value => value)
      )
    def campaignName: Optional[String]
    def vehicleName: Optional[VehicleName]
    def status: Optional[zio.aws.iotfleetwise.model.VehicleState]
    def getCampaignName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("campaignName", campaignName)
    def getVehicleName: ZIO[Any, AwsError, VehicleName] =
      AwsError.unwrapOptionField("vehicleName", vehicleName)
    def getStatus: ZIO[Any, AwsError, zio.aws.iotfleetwise.model.VehicleState] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus
  ) extends zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly {
    override val campaignName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.campaignName())
      .map(value => value: String)
    override val vehicleName: Optional[VehicleName] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicleName())
      .map(value => zio.aws.iotfleetwise.model.primitives.VehicleName(value))
    override val status: Optional[zio.aws.iotfleetwise.model.VehicleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.VehicleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus
  ): zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly = new Wrapper(impl)
}
