package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, VehicleName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateVehicleResponseItem(
    vehicleName: Optional[VehicleName] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem = {
    import UpdateVehicleResponseItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem
      .builder()
      .optionallyWith(
        vehicleName.map(value => VehicleName.unwrap(value): java.lang.String)
      )(_.vehicleName)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.wrap(buildAwsValue())
}
object UpdateVehicleResponseItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateVehicleResponseItem =
      zio.aws.iotfleetwise.model.UpdateVehicleResponseItem(
        vehicleName.map(value => value),
        arn.map(value => value)
      )
    def vehicleName: Optional[VehicleName]
    def arn: Optional[Arn]
    def getVehicleName: ZIO[Any, AwsError, VehicleName] =
      AwsError.unwrapOptionField("vehicleName", vehicleName)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem
  ) extends zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.ReadOnly {
    override val vehicleName: Optional[VehicleName] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicleName())
      .map(value => zio.aws.iotfleetwise.model.primitives.VehicleName(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem
  ): zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.ReadOnly =
    new Wrapper(impl)
}
