package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  InterfaceId,
  FullyQualifiedName,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDecoderManifestRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    signalDecodersToAdd: Optional[
      Iterable[zio.aws.iotfleetwise.model.SignalDecoder]
    ] = Optional.Absent,
    signalDecodersToUpdate: Optional[
      Iterable[zio.aws.iotfleetwise.model.SignalDecoder]
    ] = Optional.Absent,
    signalDecodersToRemove: Optional[Iterable[FullyQualifiedName]] =
      Optional.Absent,
    networkInterfacesToAdd: Optional[
      Iterable[zio.aws.iotfleetwise.model.NetworkInterface]
    ] = Optional.Absent,
    networkInterfacesToUpdate: Optional[
      Iterable[zio.aws.iotfleetwise.model.NetworkInterface]
    ] = Optional.Absent,
    networkInterfacesToRemove: Optional[Iterable[InterfaceId]] =
      Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest = {
    import UpdateDecoderManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        signalDecodersToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signalDecodersToAdd)
      .optionallyWith(
        signalDecodersToUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signalDecodersToUpdate)
      .optionallyWith(
        signalDecodersToRemove.map(value =>
          value.map { item =>
            FullyQualifiedName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.signalDecodersToRemove)
      .optionallyWith(
        networkInterfacesToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfacesToAdd)
      .optionallyWith(
        networkInterfacesToUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfacesToUpdate)
      .optionallyWith(
        networkInterfacesToRemove.map(value =>
          value.map { item =>
            InterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfacesToRemove)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.UpdateDecoderManifestRequest.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateDecoderManifestRequest
      .wrap(buildAwsValue())
}
object UpdateDecoderManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateDecoderManifestRequest =
      zio.aws.iotfleetwise.model.UpdateDecoderManifestRequest(
        name,
        description.map(value => value),
        signalDecodersToAdd.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        signalDecodersToUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        signalDecodersToRemove.map(value => value),
        networkInterfacesToAdd.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfacesToUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfacesToRemove.map(value => value),
        status.map(value => value)
      )
    def name: ResourceName
    def description: Optional[Description]
    def signalDecodersToAdd
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]]
    def signalDecodersToUpdate
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]]
    def signalDecodersToRemove: Optional[List[FullyQualifiedName]]
    def networkInterfacesToAdd
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]]
    def networkInterfacesToUpdate
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]]
    def networkInterfacesToRemove: Optional[List[InterfaceId]]
    def status: Optional[zio.aws.iotfleetwise.model.ManifestStatus]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSignalDecodersToAdd: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
    ]] = AwsError.unwrapOptionField("signalDecodersToAdd", signalDecodersToAdd)
    def getSignalDecodersToUpdate: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "signalDecodersToUpdate",
      signalDecodersToUpdate
    )
    def getSignalDecodersToRemove
        : ZIO[Any, AwsError, List[FullyQualifiedName]] = AwsError
      .unwrapOptionField("signalDecodersToRemove", signalDecodersToRemove)
    def getNetworkInterfacesToAdd: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkInterfacesToAdd",
      networkInterfacesToAdd
    )
    def getNetworkInterfacesToUpdate: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkInterfacesToUpdate",
      networkInterfacesToUpdate
    )
    def getNetworkInterfacesToRemove: ZIO[Any, AwsError, List[InterfaceId]] =
      AwsError.unwrapOptionField(
        "networkInterfacesToRemove",
        networkInterfacesToRemove
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.ManifestStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest
  ) extends zio.aws.iotfleetwise.model.UpdateDecoderManifestRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val signalDecodersToAdd
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signalDecodersToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.SignalDecoder.wrap(item)
          }.toList
        )
    override val signalDecodersToUpdate
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signalDecodersToUpdate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.SignalDecoder.wrap(item)
          }.toList
        )
    override val signalDecodersToRemove: Optional[List[FullyQualifiedName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signalDecodersToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.primitives.FullyQualifiedName(item)
          }.toList
        )
    override val networkInterfacesToAdd
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfacesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val networkInterfacesToUpdate
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfacesToUpdate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val networkInterfacesToRemove: Optional[List[InterfaceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfacesToRemove())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.primitives.InterfaceId(item)
          }.toList
        )
    override val status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.ManifestStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest
  ): zio.aws.iotfleetwise.model.UpdateDecoderManifestRequest.ReadOnly =
    new Wrapper(impl)
}
