package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FormattedVss(vssJson: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.FormattedVss = {
    import FormattedVss.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.FormattedVss
      .builder()
      .optionallyWith(vssJson.map(value => value: java.lang.String))(_.vssJson)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.FormattedVss.ReadOnly =
    zio.aws.iotfleetwise.model.FormattedVss.wrap(buildAwsValue())
}
object FormattedVss {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.FormattedVss
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.FormattedVss =
      zio.aws.iotfleetwise.model.FormattedVss(vssJson.map(value => value))
    def vssJson: Optional[String]
    def getVssJson: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vssJson", vssJson)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.FormattedVss
  ) extends zio.aws.iotfleetwise.model.FormattedVss.ReadOnly {
    override val vssJson: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vssJson())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.FormattedVss
  ): zio.aws.iotfleetwise.model.FormattedVss.ReadOnly = new Wrapper(impl)
}
