package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Message, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Branch(
    fullyQualifiedName: String,
    description: Optional[Description] = Optional.Absent,
    deprecationMessage: Optional[Message] = Optional.Absent,
    comment: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.Branch = {
    import Branch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.Branch
      .builder()
      .fullyQualifiedName(fullyQualifiedName: java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        deprecationMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.deprecationMessage)
      .optionallyWith(
        comment.map(value => Message.unwrap(value): java.lang.String)
      )(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.Branch.ReadOnly =
    zio.aws.iotfleetwise.model.Branch.wrap(buildAwsValue())
}
object Branch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.Branch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.Branch =
      zio.aws.iotfleetwise.model.Branch(
        fullyQualifiedName,
        description.map(value => value),
        deprecationMessage.map(value => value),
        comment.map(value => value)
      )
    def fullyQualifiedName: String
    def description: Optional[Description]
    def deprecationMessage: Optional[Message]
    def comment: Optional[Message]
    def getFullyQualifiedName: ZIO[Any, Nothing, String] =
      ZIO.succeed(fullyQualifiedName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeprecationMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("deprecationMessage", deprecationMessage)
    def getComment: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Branch
  ) extends zio.aws.iotfleetwise.model.Branch.ReadOnly {
    override val fullyQualifiedName: String = impl.fullyQualifiedName(): String
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val deprecationMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.deprecationMessage())
      .map(value => zio.aws.iotfleetwise.model.primitives.Message(value))
    override val comment: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.iotfleetwise.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Branch
  ): zio.aws.iotfleetwise.model.Branch.ReadOnly = new Wrapper(impl)
}
