package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait VehicleState {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.VehicleState
}
object VehicleState {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.VehicleState
  ): zio.aws.iotfleetwise.model.VehicleState = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleState.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleState.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.iotfleetwise.model.VehicleState.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.VehicleState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleState =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.iotfleetwise.model.VehicleState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleState =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleState.CREATED
  }
  case object READY extends zio.aws.iotfleetwise.model.VehicleState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleState =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleState.READY
  }
  case object HEALTHY extends zio.aws.iotfleetwise.model.VehicleState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleState =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleState.HEALTHY
  }
  case object SUSPENDED extends zio.aws.iotfleetwise.model.VehicleState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleState =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleState.SUSPENDED
  }
  case object DELETING extends zio.aws.iotfleetwise.model.VehicleState {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.VehicleState =
      software.amazon.awssdk.services.iotfleetwise.model.VehicleState.DELETING
  }
}
