package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Node(
    branch: Optional[zio.aws.iotfleetwise.model.Branch] = Optional.Absent,
    sensor: Optional[zio.aws.iotfleetwise.model.Sensor] = Optional.Absent,
    actuator: Optional[zio.aws.iotfleetwise.model.Actuator] = Optional.Absent,
    attribute: Optional[zio.aws.iotfleetwise.model.Attribute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.Node = {
    import Node.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.Node
      .builder()
      .optionallyWith(branch.map(value => value.buildAwsValue()))(_.branch)
      .optionallyWith(sensor.map(value => value.buildAwsValue()))(_.sensor)
      .optionallyWith(actuator.map(value => value.buildAwsValue()))(_.actuator)
      .optionallyWith(attribute.map(value => value.buildAwsValue()))(
        _.attribute
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.Node.ReadOnly =
    zio.aws.iotfleetwise.model.Node.wrap(buildAwsValue())
}
object Node {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iotfleetwise.model.Node] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.Node =
      zio.aws.iotfleetwise.model.Node(
        branch.map(value => value.asEditable),
        sensor.map(value => value.asEditable),
        actuator.map(value => value.asEditable),
        attribute.map(value => value.asEditable)
      )
    def branch: Optional[zio.aws.iotfleetwise.model.Branch.ReadOnly]
    def sensor: Optional[zio.aws.iotfleetwise.model.Sensor.ReadOnly]
    def actuator: Optional[zio.aws.iotfleetwise.model.Actuator.ReadOnly]
    def attribute: Optional[zio.aws.iotfleetwise.model.Attribute.ReadOnly]
    def getBranch
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.Branch.ReadOnly] =
      AwsError.unwrapOptionField("branch", branch)
    def getSensor
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.Sensor.ReadOnly] =
      AwsError.unwrapOptionField("sensor", sensor)
    def getActuator
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.Actuator.ReadOnly] =
      AwsError.unwrapOptionField("actuator", actuator)
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.Attribute.ReadOnly] =
      AwsError.unwrapOptionField("attribute", attribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Node
  ) extends zio.aws.iotfleetwise.model.Node.ReadOnly {
    override val branch: Optional[zio.aws.iotfleetwise.model.Branch.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branch())
        .map(value => zio.aws.iotfleetwise.model.Branch.wrap(value))
    override val sensor: Optional[zio.aws.iotfleetwise.model.Sensor.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sensor())
        .map(value => zio.aws.iotfleetwise.model.Sensor.wrap(value))
    override val actuator
        : Optional[zio.aws.iotfleetwise.model.Actuator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actuator())
        .map(value => zio.aws.iotfleetwise.model.Actuator.wrap(value))
    override val attribute
        : Optional[zio.aws.iotfleetwise.model.Attribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.iotfleetwise.model.Attribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Node
  ): zio.aws.iotfleetwise.model.Node.ReadOnly = new Wrapper(impl)
}
