package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFleetRequest(fleetId: FleetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest = {
    import DeleteFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.DeleteFleetRequest.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteFleetRequest.wrap(buildAwsValue())
}
object DeleteFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteFleetRequest =
      zio.aws.iotfleetwise.model.DeleteFleetRequest(fleetId)
    def fleetId: FleetId
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest
  ) extends zio.aws.iotfleetwise.model.DeleteFleetRequest.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest
  ): zio.aws.iotfleetwise.model.DeleteFleetRequest.ReadOnly = new Wrapper(impl)
}
