package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.CampaignName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCampaignRequest(name: CampaignName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest = {
    import DeleteCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest
      .builder()
      .name(CampaignName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.DeleteCampaignRequest.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteCampaignRequest.wrap(buildAwsValue())
}
object DeleteCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteCampaignRequest =
      zio.aws.iotfleetwise.model.DeleteCampaignRequest(name)
    def name: CampaignName
    def getName: ZIO[Any, Nothing, CampaignName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest
  ) extends zio.aws.iotfleetwise.model.DeleteCampaignRequest.ReadOnly {
    override val name: CampaignName =
      zio.aws.iotfleetwise.model.primitives.CampaignName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest
  ): zio.aws.iotfleetwise.model.DeleteCampaignRequest.ReadOnly = new Wrapper(
    impl
  )
}
