package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutLoggingOptionsRequest(
    cloudWatchLogDelivery: zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest = {
    import PutLoggingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest
      .builder()
      .cloudWatchLogDelivery(cloudWatchLogDelivery.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.PutLoggingOptionsRequest.ReadOnly =
    zio.aws.iotfleetwise.model.PutLoggingOptionsRequest.wrap(buildAwsValue())
}
object PutLoggingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.PutLoggingOptionsRequest =
      zio.aws.iotfleetwise.model
        .PutLoggingOptionsRequest(cloudWatchLogDelivery.asEditable)
    def cloudWatchLogDelivery
        : zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions.ReadOnly
    def getCloudWatchLogDelivery: ZIO[
      Any,
      Nothing,
      zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions.ReadOnly
    ] = ZIO.succeed(cloudWatchLogDelivery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest
  ) extends zio.aws.iotfleetwise.model.PutLoggingOptionsRequest.ReadOnly {
    override val cloudWatchLogDelivery
        : zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions.ReadOnly =
      zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions
        .wrap(impl.cloudWatchLogDelivery())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest
  ): zio.aws.iotfleetwise.model.PutLoggingOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
