package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDecoderManifestNetworkInterfacesResponse(
    networkInterfaces: Optional[
      Iterable[zio.aws.iotfleetwise.model.NetworkInterface]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse = {
    import ListDecoderManifestNetworkInterfacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse
      .builder()
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse
      .wrap(buildAwsValue())
}
object ListDecoderManifestNetworkInterfacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse =
      zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse(
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInterfaces
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse
  ) extends zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly {
    override val networkInterfaces
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse
  ): zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly =
    new Wrapper(impl)
}
