package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSignalCatalogRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest = {
    import DeleteSignalCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.DeleteSignalCatalogRequest.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteSignalCatalogRequest.wrap(buildAwsValue())
}
object DeleteSignalCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteSignalCatalogRequest =
      zio.aws.iotfleetwise.model.DeleteSignalCatalogRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest
  ) extends zio.aws.iotfleetwise.model.DeleteSignalCatalogRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest
  ): zio.aws.iotfleetwise.model.DeleteSignalCatalogRequest.ReadOnly =
    new Wrapper(impl)
}
