package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait UpdateMode {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.UpdateMode
}
object UpdateMode {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.UpdateMode
  ): zio.aws.iotfleetwise.model.UpdateMode = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.UpdateMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.UpdateMode.OVERWRITE =>
      val r = Overwrite
      r
    case software.amazon.awssdk.services.iotfleetwise.model.UpdateMode.MERGE =>
      val r = Merge
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.UpdateMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.UpdateMode =
      software.amazon.awssdk.services.iotfleetwise.model.UpdateMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Overwrite extends zio.aws.iotfleetwise.model.UpdateMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.UpdateMode =
      software.amazon.awssdk.services.iotfleetwise.model.UpdateMode.OVERWRITE
  }
  case object Merge extends zio.aws.iotfleetwise.model.UpdateMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.UpdateMode =
      software.amazon.awssdk.services.iotfleetwise.model.UpdateMode.MERGE
  }
}
