package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteModelManifestResponse(name: ResourceName, arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse = {
    import DeleteModelManifestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteModelManifestResponse.wrap(buildAwsValue())
}
object DeleteModelManifestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteModelManifestResponse =
      zio.aws.iotfleetwise.model.DeleteModelManifestResponse(name, arn)
    def name: ResourceName
    def arn: Arn
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse
  ) extends zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestResponse
  ): zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly =
    new Wrapper(impl)
}
