package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Description, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSignalCatalogRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    nodes: Optional[Iterable[zio.aws.iotfleetwise.model.Node]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotfleetwise.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest = {
    import CreateSignalCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.CreateSignalCatalogRequest.ReadOnly =
    zio.aws.iotfleetwise.model.CreateSignalCatalogRequest.wrap(buildAwsValue())
}
object CreateSignalCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateSignalCatalogRequest =
      zio.aws.iotfleetwise.model.CreateSignalCatalogRequest(
        name,
        description.map(value => value),
        nodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResourceName
    def description: Optional[Description]
    def nodes: Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]]
    def tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNodes
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodes", nodes)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest
  ) extends zio.aws.iotfleetwise.model.CreateSignalCatalogRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val nodes
        : Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Node.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest
  ): zio.aws.iotfleetwise.model.CreateSignalCatalogRequest.ReadOnly =
    new Wrapper(impl)
}
