package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{NextToken, VehicleName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVehiclesInFleetResponse(
    vehicles: Optional[Iterable[VehicleName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse = {
    import ListVehiclesInFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse
      .builder()
      .optionallyWith(
        vehicles.map(value =>
          value.map { item =>
            VehicleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vehicles)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.wrap(buildAwsValue())
}
object ListVehiclesInFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse =
      zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse(
        vehicles.map(value => value),
        nextToken.map(value => value)
      )
    def vehicles: Optional[List[VehicleName]]
    def nextToken: Optional[NextToken]
    def getVehicles: ZIO[Any, AwsError, List[VehicleName]] =
      AwsError.unwrapOptionField("vehicles", vehicles)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse
  ) extends zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly {
    override val vehicles: Optional[List[VehicleName]] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.primitives.VehicleName(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse
  ): zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly =
    new Wrapper(impl)
}
