package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFleetRequest(fleetId: FleetId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest = {
    import GetFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetFleetRequest.ReadOnly =
    zio.aws.iotfleetwise.model.GetFleetRequest.wrap(buildAwsValue())
}
object GetFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetFleetRequest =
      zio.aws.iotfleetwise.model.GetFleetRequest(fleetId)
    def fleetId: FleetId
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest
  ) extends zio.aws.iotfleetwise.model.GetFleetRequest.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest
  ): zio.aws.iotfleetwise.model.GetFleetRequest.ReadOnly = new Wrapper(impl)
}
