package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, VehicleName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVehicleResponse(vehicleName: VehicleName, arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse = {
    import DeleteVehicleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteVehicleResponse.wrap(buildAwsValue())
}
object DeleteVehicleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteVehicleResponse =
      zio.aws.iotfleetwise.model.DeleteVehicleResponse(vehicleName, arn)
    def vehicleName: VehicleName
    def arn: Arn
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse
  ) extends zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleResponse
  ): zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly = new Wrapper(
    impl
  )
}
