package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  AttributeValue,
  AttributeName,
  Arn,
  VehicleName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVehicleRequestItem(
    vehicleName: VehicleName,
    modelManifestArn: Arn,
    decoderManifestArn: Arn,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    associationBehavior: Optional[
      zio.aws.iotfleetwise.model.VehicleAssociationBehavior
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotfleetwise.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequestItem = {
    import CreateVehicleRequestItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequestItem
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .modelManifestArn(Arn.unwrap(modelManifestArn): java.lang.String)
      .decoderManifestArn(Arn.unwrap(decoderManifestArn): java.lang.String)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(associationBehavior.map(value => value.unwrap))(
        _.associationBehavior
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CreateVehicleRequestItem.ReadOnly =
    zio.aws.iotfleetwise.model.CreateVehicleRequestItem.wrap(buildAwsValue())
}
object CreateVehicleRequestItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequestItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateVehicleRequestItem =
      zio.aws.iotfleetwise.model.CreateVehicleRequestItem(
        vehicleName,
        modelManifestArn,
        decoderManifestArn,
        attributes.map(value => value),
        associationBehavior.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vehicleName: VehicleName
    def modelManifestArn: Arn
    def decoderManifestArn: Arn
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def associationBehavior
        : Optional[zio.aws.iotfleetwise.model.VehicleAssociationBehavior]
    def tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]]
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
    def getModelManifestArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(modelManifestArn)
    def getDecoderManifestArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(decoderManifestArn)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getAssociationBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.VehicleAssociationBehavior
    ] = AwsError.unwrapOptionField("associationBehavior", associationBehavior)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequestItem
  ) extends zio.aws.iotfleetwise.model.CreateVehicleRequestItem.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
    override val modelManifestArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.modelManifestArn())
    override val decoderManifestArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.decoderManifestArn())
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotfleetwise.model.primitives.AttributeName(
                key
              ) -> zio.aws.iotfleetwise.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val associationBehavior
        : Optional[zio.aws.iotfleetwise.model.VehicleAssociationBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationBehavior())
        .map(value =>
          zio.aws.iotfleetwise.model.VehicleAssociationBehavior.wrap(value)
        )
    override val tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequestItem
  ): zio.aws.iotfleetwise.model.CreateVehicleRequestItem.ReadOnly = new Wrapper(
    impl
  )
}
