package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.VehicleName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVehicleError(
    vehicleName: Optional[VehicleName] = Optional.Absent,
    code: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleError = {
    import CreateVehicleError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleError
      .builder()
      .optionallyWith(
        vehicleName.map(value => VehicleName.unwrap(value): java.lang.String)
      )(_.vehicleName)
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CreateVehicleError.ReadOnly =
    zio.aws.iotfleetwise.model.CreateVehicleError.wrap(buildAwsValue())
}
object CreateVehicleError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateVehicleError =
      zio.aws.iotfleetwise.model.CreateVehicleError(
        vehicleName.map(value => value),
        code.map(value => value),
        message.map(value => value)
      )
    def vehicleName: Optional[VehicleName]
    def code: Optional[String]
    def message: Optional[String]
    def getVehicleName: ZIO[Any, AwsError, VehicleName] =
      AwsError.unwrapOptionField("vehicleName", vehicleName)
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleError
  ) extends zio.aws.iotfleetwise.model.CreateVehicleError.ReadOnly {
    override val vehicleName: Optional[VehicleName] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicleName())
      .map(value => zio.aws.iotfleetwise.model.primitives.VehicleName(value))
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleError
  ): zio.aws.iotfleetwise.model.CreateVehicleError.ReadOnly = new Wrapper(impl)
}
