package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateModelManifestResponse(name: ResourceName, arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse = {
    import CreateModelManifestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly =
    zio.aws.iotfleetwise.model.CreateModelManifestResponse.wrap(buildAwsValue())
}
object CreateModelManifestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateModelManifestResponse =
      zio.aws.iotfleetwise.model.CreateModelManifestResponse(name, arn)
    def name: ResourceName
    def arn: Arn
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse
  ) extends zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestResponse
  ): zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly =
    new Wrapper(impl)
}
