package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelManifestNodesResponse(
    nodes: Optional[Iterable[zio.aws.iotfleetwise.model.Node]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse = {
    import ListModelManifestNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse
      .builder()
      .optionallyWith(
        nodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListModelManifestNodesResponse
      .wrap(buildAwsValue())
}
object ListModelManifestNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListModelManifestNodesResponse =
      zio.aws.iotfleetwise.model.ListModelManifestNodesResponse(
        nodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def nodes: Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getNodes
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodes", nodes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse
  ) extends zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly {
    override val nodes
        : Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Node.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesResponse
  ): zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly =
    new Wrapper(impl)
}
