package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSignalCatalogResponse(name: ResourceName, arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse = {
    import DeleteSignalCatalogResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.wrap(buildAwsValue())
}
object DeleteSignalCatalogResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse =
      zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse(name, arn)
    def name: ResourceName
    def arn: Arn
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse
  ) extends zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogResponse
  ): zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly =
    new Wrapper(impl)
}
