package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteModelManifestRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest = {
    import DeleteModelManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.DeleteModelManifestRequest.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteModelManifestRequest.wrap(buildAwsValue())
}
object DeleteModelManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteModelManifestRequest =
      zio.aws.iotfleetwise.model.DeleteModelManifestRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest
  ) extends zio.aws.iotfleetwise.model.DeleteModelManifestRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest
  ): zio.aws.iotfleetwise.model.DeleteModelManifestRequest.ReadOnly =
    new Wrapper(impl)
}
