package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateDecoderManifestResponse(name: ResourceName, arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse = {
    import CreateDecoderManifestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly =
    zio.aws.iotfleetwise.model.CreateDecoderManifestResponse
      .wrap(buildAwsValue())
}
object CreateDecoderManifestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateDecoderManifestResponse =
      zio.aws.iotfleetwise.model.CreateDecoderManifestResponse(name, arn)
    def name: ResourceName
    def arn: Arn
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse
  ) extends zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestResponse
  ): zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly =
    new Wrapper(impl)
}
