package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{MaxResults, NextToken, Arn}
import scala.jdk.CollectionConverters._
final case class ListModelManifestsRequest(
    signalCatalogArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest = {
    import ListModelManifestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest
      .builder()
      .optionallyWith(
        signalCatalogArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.signalCatalogArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListModelManifestsRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ListModelManifestsRequest.wrap(buildAwsValue())
}
object ListModelManifestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListModelManifestsRequest =
      zio.aws.iotfleetwise.model.ListModelManifestsRequest(
        signalCatalogArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def signalCatalogArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSignalCatalogArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("signalCatalogArn", signalCatalogArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest
  ) extends zio.aws.iotfleetwise.model.ListModelManifestsRequest.ReadOnly {
    override val signalCatalogArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.signalCatalogArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotfleetwise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest
  ): zio.aws.iotfleetwise.model.ListModelManifestsRequest.ReadOnly =
    new Wrapper(impl)
}
