package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, Description, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDecoderManifestRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    modelManifestArn: Arn,
    signalDecoders: Optional[
      Iterable[zio.aws.iotfleetwise.model.SignalDecoder]
    ] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.iotfleetwise.model.NetworkInterface]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotfleetwise.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest = {
    import CreateDecoderManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .modelManifestArn(Arn.unwrap(modelManifestArn): java.lang.String)
      .optionallyWith(
        signalDecoders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signalDecoders)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.CreateDecoderManifestRequest.ReadOnly =
    zio.aws.iotfleetwise.model.CreateDecoderManifestRequest
      .wrap(buildAwsValue())
}
object CreateDecoderManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateDecoderManifestRequest =
      zio.aws.iotfleetwise.model.CreateDecoderManifestRequest(
        name,
        description.map(value => value),
        modelManifestArn,
        signalDecoders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResourceName
    def description: Optional[Description]
    def modelManifestArn: Arn
    def signalDecoders
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]]
    def networkInterfaces
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]]
    def tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getModelManifestArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(modelManifestArn)
    def getSignalDecoders: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
    ]] = AwsError.unwrapOptionField("signalDecoders", signalDecoders)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest
  ) extends zio.aws.iotfleetwise.model.CreateDecoderManifestRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val modelManifestArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.modelManifestArn())
    override val signalDecoders
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signalDecoders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.SignalDecoder.wrap(item)
          }.toList
        )
    override val networkInterfaces
        : Optional[List[zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.NetworkInterface.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest
  ): zio.aws.iotfleetwise.model.CreateDecoderManifestRequest.ReadOnly =
    new Wrapper(impl)
}
