package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{CampaignName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCampaignResponse(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[CampaignName] = Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.CampaignStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse = {
    import UpdateCampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => CampaignName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateCampaignResponse.wrap(buildAwsValue())
}
object UpdateCampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateCampaignResponse =
      zio.aws.iotfleetwise.model.UpdateCampaignResponse(
        arn.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[Arn]
    def name: Optional[CampaignName]
    def status: Optional[zio.aws.iotfleetwise.model.CampaignStatus]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, CampaignName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.CampaignStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse
  ) extends zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val name: Optional[CampaignName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotfleetwise.model.primitives.CampaignName(value))
    override val status: Optional[zio.aws.iotfleetwise.model.CampaignStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.CampaignStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignResponse
  ): zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly = new Wrapper(
    impl
  )
}
