package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVehiclesResponse(
    vehicleSummaries: Optional[
      Iterable[zio.aws.iotfleetwise.model.VehicleSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse = {
    import ListVehiclesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse
      .builder()
      .optionallyWith(
        vehicleSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vehicleSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListVehiclesResponse.wrap(buildAwsValue())
}
object ListVehiclesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListVehiclesResponse =
      zio.aws.iotfleetwise.model.ListVehiclesResponse(
        vehicleSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vehicleSummaries
        : Optional[List[zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVehicleSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("vehicleSummaries", vehicleSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse
  ) extends zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly {
    override val vehicleSummaries
        : Optional[List[zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vehicleSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.VehicleSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse
  ): zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly = new Wrapper(
    impl
  )
}
