package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{NetworkFileBlob, InterfaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CanDbcDefinition(
    networkInterface: InterfaceId,
    canDbcFiles: Iterable[NetworkFileBlob],
    signalsMap: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CanDbcDefinition = {
    import CanDbcDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CanDbcDefinition
      .builder()
      .networkInterface(InterfaceId.unwrap(networkInterface): java.lang.String)
      .canDbcFiles(canDbcFiles.map { item =>
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(item.toArray[Byte])
      }.asJavaCollection)
      .optionallyWith(
        signalsMap.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.signalsMap)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CanDbcDefinition.ReadOnly =
    zio.aws.iotfleetwise.model.CanDbcDefinition.wrap(buildAwsValue())
}
object CanDbcDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CanDbcDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CanDbcDefinition =
      zio.aws.iotfleetwise.model.CanDbcDefinition(
        networkInterface,
        canDbcFiles,
        signalsMap.map(value => value)
      )
    def networkInterface: InterfaceId
    def canDbcFiles: List[NetworkFileBlob]
    def signalsMap: Optional[Map[String, String]]
    def getNetworkInterface: ZIO[Any, Nothing, InterfaceId] =
      ZIO.succeed(networkInterface)
    def getCanDbcFiles: ZIO[Any, Nothing, List[NetworkFileBlob]] =
      ZIO.succeed(canDbcFiles)
    def getSignalsMap: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("signalsMap", signalsMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CanDbcDefinition
  ) extends zio.aws.iotfleetwise.model.CanDbcDefinition.ReadOnly {
    override val networkInterface: InterfaceId =
      zio.aws.iotfleetwise.model.primitives.InterfaceId(impl.networkInterface())
    override val canDbcFiles: List[NetworkFileBlob] = impl
      .canDbcFiles()
      .asScala
      .map { item =>
        zio.aws.iotfleetwise.model.primitives
          .NetworkFileBlob(zio.Chunk.fromArray(item.asByteArrayUnsafe()))
      }
      .toList
    override val signalsMap: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signalsMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CanDbcDefinition
  ): zio.aws.iotfleetwise.model.CanDbcDefinition.ReadOnly = new Wrapper(impl)
}
