package zio.aws.iotfleetwise
import zio.aws.iotfleetwise.model.UpdateSignalCatalogResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.iotfleetwise.model.{
  ImportSignalCatalogRequest,
  ListVehiclesInFleetRequest,
  CreateDecoderManifestRequest,
  ListFleetsRequest,
  GetLoggingOptionsRequest,
  GetRegisterAccountStatusRequest,
  BatchUpdateVehicleRequest,
  DeleteVehicleRequest,
  GetFleetRequest,
  ListDecoderManifestNetworkInterfacesRequest,
  GetModelManifestRequest,
  BatchCreateVehicleRequest,
  ListModelManifestNodesRequest,
  CreateSignalCatalogRequest,
  GetSignalCatalogRequest,
  ListModelManifestsRequest,
  GetVehicleStatusRequest,
  ListTagsForResourceRequest,
  RegisterAccountRequest,
  ListFleetsForVehicleRequest,
  UpdateCampaignRequest,
  GetCampaignRequest,
  CreateModelManifestRequest,
  ListVehiclesRequest,
  ListSignalCatalogsRequest,
  GetVehicleRequest,
  UpdateModelManifestRequest,
  GetDecoderManifestRequest,
  UpdateDecoderManifestRequest,
  UpdateSignalCatalogRequest,
  CreateCampaignRequest,
  DisassociateVehicleFleetRequest,
  DeleteCampaignRequest,
  ListDecoderManifestSignalsRequest,
  AssociateVehicleFleetRequest,
  UpdateFleetRequest,
  CreateFleetRequest,
  CreateVehicleRequest,
  PutLoggingOptionsRequest,
  DeleteDecoderManifestRequest,
  DeleteModelManifestRequest,
  UntagResourceRequest,
  ListDecoderManifestsRequest,
  DeleteSignalCatalogRequest,
  UpdateVehicleRequest,
  ListCampaignsRequest,
  ImportDecoderManifestRequest,
  ListSignalCatalogNodesRequest,
  TagResourceRequest,
  DeleteFleetRequest
}
import software.amazon.awssdk.services.iotfleetwise.{
  IoTFleetWiseAsyncClientBuilder,
  IoTFleetWiseAsyncClient
}
import software.amazon.awssdk.services.iotfleetwise.paginators.{
  ListSignalCatalogsPublisher,
  ListDecoderManifestNetworkInterfacesPublisher,
  ListDecoderManifestsPublisher,
  ListVehiclesInFleetPublisher,
  ListModelManifestNodesPublisher,
  ListFleetsForVehiclePublisher,
  ListSignalCatalogNodesPublisher,
  GetVehicleStatusPublisher,
  ListCampaignsPublisher,
  ListModelManifestsPublisher,
  ListFleetsPublisher,
  ListVehiclesPublisher,
  ListDecoderManifestSignalsPublisher
}
import zio.stream.ZStream
import software.amazon.awssdk.services.iotfleetwise.model.{
  GetFleetResponse,
  ImportDecoderManifestResponse,
  GetLoggingOptionsResponse,
  CreateModelManifestResponse,
  AssociateVehicleFleetResponse,
  BatchCreateVehicleResponse,
  CreateFleetResponse,
  NetworkInterface,
  DeleteFleetResponse,
  DeleteDecoderManifestResponse,
  DeleteVehicleResponse,
  ListVehiclesResponse,
  ListFleetsForVehicleResponse,
  GetVehicleStatusResponse,
  ListFleetsResponse,
  ListDecoderManifestNetworkInterfacesResponse,
  ListDecoderManifestsResponse,
  VehicleSummary,
  GetVehicleResponse,
  ImportSignalCatalogResponse,
  UpdateVehicleResponse,
  SignalDecoder,
  CreateSignalCatalogResponse,
  ListTagsForResourceResponse,
  BatchUpdateVehicleResponse,
  UntagResourceResponse,
  RegisterAccountResponse,
  PutLoggingOptionsResponse,
  GetDecoderManifestResponse,
  DeleteModelManifestResponse,
  ListVehiclesInFleetResponse,
  GetRegisterAccountStatusResponse,
  ListCampaignsResponse,
  UpdateDecoderManifestResponse,
  Node,
  ModelManifestSummary,
  GetModelManifestResponse,
  CampaignSummary,
  GetCampaignResponse,
  ListModelManifestNodesResponse,
  GetSignalCatalogResponse,
  DisassociateVehicleFleetResponse,
  UpdateModelManifestResponse,
  ListModelManifestsResponse,
  DecoderManifestSummary,
  DeleteCampaignResponse,
  CreateCampaignResponse,
  UpdateCampaignResponse,
  SignalCatalogSummary,
  DeleteSignalCatalogResponse,
  UpdateSignalCatalogResponse,
  ListSignalCatalogsResponse,
  FleetSummary,
  TagResourceResponse,
  ListSignalCatalogNodesResponse,
  CreateDecoderManifestResponse,
  UpdateFleetResponse,
  VehicleStatus,
  CreateVehicleResponse,
  ListDecoderManifestSignalsResponse
}
import zio.aws.iotfleetwise.model.primitives.{VehicleName, FleetId}
import scala.jdk.CollectionConverters._
trait IoTFleetWise extends AspectSupport[IoTFleetWise] {
  val api: IoTFleetWiseAsyncClient
  def listDecoderManifestNetworkInterfaces(
      request: ListDecoderManifestNetworkInterfacesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
  ]
  def listDecoderManifestNetworkInterfacesPaginated(
      request: ListDecoderManifestNetworkInterfacesRequest
  ): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly
  ]
  def getDecoderManifest(request: GetDecoderManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly
  ]
  def deleteCampaign(
      request: DeleteCampaignRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.DeleteCampaignResponse.ReadOnly]
  def getCampaign(
      request: GetCampaignRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly]
  def updateVehicle(
      request: UpdateVehicleRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.UpdateVehicleResponse.ReadOnly]
  def deleteModelManifest(request: DeleteModelManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly
  ]
  def listCampaigns(
      request: ListCampaignsRequest
  ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly]
  def listCampaignsPaginated(
      request: ListCampaignsRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly]
  def registerAccount(
      request: RegisterAccountRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly]
  def deleteVehicle(
      request: DeleteVehicleRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly]
  def deleteDecoderManifest(request: DeleteDecoderManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.DeleteDecoderManifestResponse.ReadOnly
  ]
  def importSignalCatalog(request: ImportSignalCatalogRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ImportSignalCatalogResponse.ReadOnly
  ]
  def listFleetsForVehicle(
      request: ListFleetsForVehicleRequest
  ): ZStream[Any, AwsError, FleetId]
  def listFleetsForVehiclePaginated(request: ListFleetsForVehicleRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly
  ]
  def disassociateVehicleFleet(request: DisassociateVehicleFleetRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.DisassociateVehicleFleetResponse.ReadOnly
  ]
  def listFleets(
      request: ListFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.FleetSummary.ReadOnly]
  def listFleetsPaginated(
      request: ListFleetsRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly]
  def listSignalCatalogNodes(
      request: ListSignalCatalogNodesRequest
  ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.Node.ReadOnly]
  def listSignalCatalogNodesPaginated(
      request: ListSignalCatalogNodesRequest
  ): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListSignalCatalogNodesResponse.ReadOnly
  ]
  def importDecoderManifest(request: ImportDecoderManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ImportDecoderManifestResponse.ReadOnly
  ]
  def createVehicle(
      request: CreateVehicleRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.CreateVehicleResponse.ReadOnly]
  def updateSignalCatalog(
      request: UpdateSignalCatalogRequest
  ): IO[AwsError, ReadOnly]
  def listModelManifests(request: ListModelManifestsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly
  ]
  def listModelManifestsPaginated(request: ListModelManifestsRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly
  ]
  def deleteFleet(
      request: DeleteFleetRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly]
  def putLoggingOptions(
      request: PutLoggingOptionsRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.PutLoggingOptionsResponse.ReadOnly]
  def listVehicles(
      request: ListVehiclesRequest
  ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly]
  def listVehiclesPaginated(
      request: ListVehiclesRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly]
  def updateFleet(
      request: UpdateFleetRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly]
  def createModelManifest(request: CreateModelManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly
  ]
  def listDecoderManifests(request: ListDecoderManifestsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly
  ]
  def listDecoderManifestsPaginated(request: ListDecoderManifestsRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly
  ]
  def getFleet(
      request: GetFleetRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly]
  def deleteSignalCatalog(request: DeleteSignalCatalogRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly
  ]
  def getModelManifest(
      request: GetModelManifestRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.GetModelManifestResponse.ReadOnly]
  def createFleet(
      request: CreateFleetRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly]
  def getVehicle(
      request: GetVehicleRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly]
  def getRegisterAccountStatus(request: GetRegisterAccountStatusRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.UntagResourceResponse.ReadOnly]
  def listDecoderManifestSignals(
      request: ListDecoderManifestSignalsRequest
  ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]
  def listDecoderManifestSignalsPaginated(
      request: ListDecoderManifestSignalsRequest
  ): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly
  ]
  def batchUpdateVehicle(request: BatchUpdateVehicleRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly
  ]
  def associateVehicleFleet(request: AssociateVehicleFleetRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.AssociateVehicleFleetResponse.ReadOnly
  ]
  def createCampaign(
      request: CreateCampaignRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.TagResourceResponse.ReadOnly]
  def getVehicleStatus(
      request: GetVehicleStatusRequest
  ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly]
  def getVehicleStatusPaginated(
      request: GetVehicleStatusRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly]
  def listSignalCatalogs(request: ListSignalCatalogsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly
  ]
  def listSignalCatalogsPaginated(request: ListSignalCatalogsRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly
  ]
  def listModelManifestNodes(
      request: ListModelManifestNodesRequest
  ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.Node.ReadOnly]
  def listModelManifestNodesPaginated(
      request: ListModelManifestNodesRequest
  ): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly
  ]
  def createSignalCatalog(request: CreateSignalCatalogRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.CreateSignalCatalogResponse.ReadOnly
  ]
  def batchCreateVehicle(request: BatchCreateVehicleRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly
  ]
  def getLoggingOptions(
      request: GetLoggingOptionsRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.GetLoggingOptionsResponse.ReadOnly]
  def updateDecoderManifest(request: UpdateDecoderManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly
  ]
  def createDecoderManifest(request: CreateDecoderManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly
  ]
  def listVehiclesInFleet(
      request: ListVehiclesInFleetRequest
  ): ZStream[Any, AwsError, VehicleName]
  def listVehiclesInFleetPaginated(request: ListVehiclesInFleetRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly
  ]
  def updateModelManifest(request: UpdateModelManifestRequest): IO[
    AwsError,
    zio.aws.iotfleetwise.model.UpdateModelManifestResponse.ReadOnly
  ]
  def updateCampaign(
      request: UpdateCampaignRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly]
  def getSignalCatalog(
      request: GetSignalCatalogRequest
  ): IO[AwsError, zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly]
}
object IoTFleetWise {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTFleetWise] = customized(
    identity
  )
  def customized(
      customization: IoTFleetWiseAsyncClientBuilder => IoTFleetWiseAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTFleetWise] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IoTFleetWiseAsyncClientBuilder => IoTFleetWiseAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IoTFleetWise] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IoTFleetWiseAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IoTFleetWiseAsyncClient, IoTFleetWiseAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IoTFleetWiseAsyncClient,
      IoTFleetWiseAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IoTFleetWiseImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTFleetWiseImpl[R](
      override val api: IoTFleetWiseAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTFleetWise
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTFleetWise"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTFleetWiseImpl[R1] = new IoTFleetWiseImpl(api, newAspect, r)
    def listDecoderManifestNetworkInterfaces(
        request: ListDecoderManifestNetworkInterfacesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest,
      NetworkInterface,
      ListDecoderManifestNetworkInterfacesPublisher
    ](
      "listDecoderManifestNetworkInterfaces",
      api.listDecoderManifestNetworkInterfacesPaginator,
      _.networkInterfaces()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotfleetwise.model.NetworkInterface.wrap(item))
      .provideEnvironment(r)
    def listDecoderManifestNetworkInterfacesPaginated(
        request: ListDecoderManifestNetworkInterfacesRequest
    ): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest,
      ListDecoderManifestNetworkInterfacesResponse
    ](
      "listDecoderManifestNetworkInterfaces",
      api.listDecoderManifestNetworkInterfaces
    )(request.buildAwsValue())
      .map(
        zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.wrap
      )
      .provideEnvironment(r)
    def getDecoderManifest(request: GetDecoderManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestRequest,
      GetDecoderManifestResponse
    ]("getDecoderManifest", api.getDecoderManifest)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.GetDecoderManifestResponse.wrap)
      .provideEnvironment(r)
    def deleteCampaign(request: DeleteCampaignRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.DeleteCampaignResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.DeleteCampaignRequest,
      DeleteCampaignResponse
    ]("deleteCampaign", api.deleteCampaign)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.DeleteCampaignResponse.wrap)
      .provideEnvironment(r)
    def getCampaign(
        request: GetCampaignRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.GetCampaignRequest,
        GetCampaignResponse
      ]("getCampaign", api.getCampaign)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.GetCampaignResponse.wrap)
        .provideEnvironment(r)
    def updateVehicle(
        request: UpdateVehicleRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.UpdateVehicleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequest,
        UpdateVehicleResponse
      ]("updateVehicle", api.updateVehicle)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.UpdateVehicleResponse.wrap)
        .provideEnvironment(r)
    def deleteModelManifest(request: DeleteModelManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.DeleteModelManifestRequest,
      DeleteModelManifestResponse
    ]("deleteModelManifest", api.deleteModelManifest)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.DeleteModelManifestResponse.wrap)
      .provideEnvironment(r)
    def listCampaigns(request: ListCampaignsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest,
      CampaignSummary,
      ListCampaignsPublisher
    ]("listCampaigns", api.listCampaignsPaginator, _.campaignSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.CampaignSummary.wrap(item))
      .provideEnvironment(r)
    def listCampaignsPaginated(
        request: ListCampaignsRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest,
        ListCampaignsResponse
      ]("listCampaigns", api.listCampaigns)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.ListCampaignsResponse.wrap)
        .provideEnvironment(r)
    def registerAccount(request: RegisterAccountRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.RegisterAccountRequest,
      RegisterAccountResponse
    ]("registerAccount", api.registerAccount)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.RegisterAccountResponse.wrap)
      .provideEnvironment(r)
    def deleteVehicle(
        request: DeleteVehicleRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest,
        DeleteVehicleResponse
      ]("deleteVehicle", api.deleteVehicle)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.DeleteVehicleResponse.wrap)
        .provideEnvironment(r)
    def deleteDecoderManifest(request: DeleteDecoderManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.DeleteDecoderManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.DeleteDecoderManifestRequest,
      DeleteDecoderManifestResponse
    ]("deleteDecoderManifest", api.deleteDecoderManifest)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.DeleteDecoderManifestResponse.wrap)
      .provideEnvironment(r)
    def importSignalCatalog(request: ImportSignalCatalogRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ImportSignalCatalogResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest,
      ImportSignalCatalogResponse
    ]("importSignalCatalog", api.importSignalCatalog)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.ImportSignalCatalogResponse.wrap)
      .provideEnvironment(r)
    def listFleetsForVehicle(
        request: ListFleetsForVehicleRequest
    ): ZStream[Any, AwsError, FleetId] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest,
      java.lang.String,
      ListFleetsForVehiclePublisher
    ]("listFleetsForVehicle", api.listFleetsForVehiclePaginator, _.fleets())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.primitives.FleetId(item))
      .provideEnvironment(r)
    def listFleetsForVehiclePaginated(request: ListFleetsForVehicleRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest,
      ListFleetsForVehicleResponse
    ]("listFleetsForVehicle", api.listFleetsForVehicle)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.wrap)
      .provideEnvironment(r)
    def disassociateVehicleFleet(request: DisassociateVehicleFleetRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.DisassociateVehicleFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest,
      DisassociateVehicleFleetResponse
    ]("disassociateVehicleFleet", api.disassociateVehicleFleet)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.DisassociateVehicleFleetResponse.wrap)
      .provideEnvironment(r)
    def listFleets(request: ListFleetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.FleetSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest,
      FleetSummary,
      ListFleetsPublisher
    ]("listFleets", api.listFleetsPaginator, _.fleetSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.FleetSummary.wrap(item))
      .provideEnvironment(r)
    def listFleetsPaginated(
        request: ListFleetsRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.ListFleetsRequest,
        ListFleetsResponse
      ]("listFleets", api.listFleets)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.ListFleetsResponse.wrap)
        .provideEnvironment(r)
    def listSignalCatalogNodes(
        request: ListSignalCatalogNodesRequest
    ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.Node.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest,
        Node,
        ListSignalCatalogNodesPublisher
      ](
        "listSignalCatalogNodes",
        api.listSignalCatalogNodesPaginator,
        _.nodes()
      )(request.buildAwsValue())
        .map(item => zio.aws.iotfleetwise.model.Node.wrap(item))
        .provideEnvironment(r)
    def listSignalCatalogNodesPaginated(
        request: ListSignalCatalogNodesRequest
    ): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListSignalCatalogNodesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogNodesRequest,
      ListSignalCatalogNodesResponse
    ]("listSignalCatalogNodes", api.listSignalCatalogNodes)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.ListSignalCatalogNodesResponse.wrap)
      .provideEnvironment(r)
    def importDecoderManifest(request: ImportDecoderManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ImportDecoderManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ImportDecoderManifestRequest,
      ImportDecoderManifestResponse
    ]("importDecoderManifest", api.importDecoderManifest)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.ImportDecoderManifestResponse.wrap)
      .provideEnvironment(r)
    def createVehicle(
        request: CreateVehicleRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.CreateVehicleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleRequest,
        CreateVehicleResponse
      ]("createVehicle", api.createVehicle)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.CreateVehicleResponse.wrap)
        .provideEnvironment(r)
    def updateSignalCatalog(
        request: UpdateSignalCatalogRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest,
      UpdateSignalCatalogResponse
    ]("updateSignalCatalog", api.updateSignalCatalog)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.UpdateSignalCatalogResponse.wrap)
      .provideEnvironment(r)
    def listModelManifests(request: ListModelManifestsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest,
      ModelManifestSummary,
      ListModelManifestsPublisher
    ]("listModelManifests", api.listModelManifestsPaginator, _.summaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.ModelManifestSummary.wrap(item))
      .provideEnvironment(r)
    def listModelManifestsPaginated(request: ListModelManifestsRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest,
      ListModelManifestsResponse
    ]("listModelManifests", api.listModelManifests)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.ListModelManifestsResponse.wrap)
      .provideEnvironment(r)
    def deleteFleet(
        request: DeleteFleetRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetRequest,
        DeleteFleetResponse
      ]("deleteFleet", api.deleteFleet)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.DeleteFleetResponse.wrap)
        .provideEnvironment(r)
    def putLoggingOptions(request: PutLoggingOptionsRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.PutLoggingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.PutLoggingOptionsRequest,
      PutLoggingOptionsResponse
    ]("putLoggingOptions", api.putLoggingOptions)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.PutLoggingOptionsResponse.wrap)
      .provideEnvironment(r)
    def listVehicles(request: ListVehiclesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest,
      VehicleSummary,
      ListVehiclesPublisher
    ]("listVehicles", api.listVehiclesPaginator, _.vehicleSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.VehicleSummary.wrap(item))
      .provideEnvironment(r)
    def listVehiclesPaginated(
        request: ListVehiclesRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest,
        ListVehiclesResponse
      ]("listVehicles", api.listVehicles)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.ListVehiclesResponse.wrap)
        .provideEnvironment(r)
    def updateFleet(
        request: UpdateFleetRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.UpdateFleetRequest,
        UpdateFleetResponse
      ]("updateFleet", api.updateFleet)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.UpdateFleetResponse.wrap)
        .provideEnvironment(r)
    def createModelManifest(request: CreateModelManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest,
      CreateModelManifestResponse
    ]("createModelManifest", api.createModelManifest)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.CreateModelManifestResponse.wrap)
      .provideEnvironment(r)
    def listDecoderManifests(request: ListDecoderManifestsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest,
      DecoderManifestSummary,
      ListDecoderManifestsPublisher
    ]("listDecoderManifests", api.listDecoderManifestsPaginator, _.summaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.DecoderManifestSummary.wrap(item))
      .provideEnvironment(r)
    def listDecoderManifestsPaginated(request: ListDecoderManifestsRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestsRequest,
      ListDecoderManifestsResponse
    ]("listDecoderManifests", api.listDecoderManifests)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.wrap)
      .provideEnvironment(r)
    def getFleet(
        request: GetFleetRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.GetFleetRequest,
        GetFleetResponse
      ]("getFleet", api.getFleet)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.GetFleetResponse.wrap)
        .provideEnvironment(r)
    def deleteSignalCatalog(request: DeleteSignalCatalogRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.DeleteSignalCatalogRequest,
      DeleteSignalCatalogResponse
    ]("deleteSignalCatalog", api.deleteSignalCatalog)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.wrap)
      .provideEnvironment(r)
    def getModelManifest(request: GetModelManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.GetModelManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest,
      GetModelManifestResponse
    ]("getModelManifest", api.getModelManifest)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.GetModelManifestResponse.wrap)
      .provideEnvironment(r)
    def createFleet(
        request: CreateFleetRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest,
        CreateFleetResponse
      ]("createFleet", api.createFleet)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.CreateFleetResponse.wrap)
        .provideEnvironment(r)
    def getVehicle(
        request: GetVehicleRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.GetVehicleRequest,
        GetVehicleResponse
      ]("getVehicle", api.getVehicle)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.GetVehicleResponse.wrap)
        .provideEnvironment(r)
    def getRegisterAccountStatus(request: GetRegisterAccountStatusRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.GetRegisterAccountStatusRequest,
      GetRegisterAccountStatusResponse
    ]("getRegisterAccountStatus", api.getRegisterAccountStatus)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listDecoderManifestSignals(
        request: ListDecoderManifestSignalsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest,
      SignalDecoder,
      ListDecoderManifestSignalsPublisher
    ](
      "listDecoderManifestSignals",
      api.listDecoderManifestSignalsPaginator,
      _.signalDecoders()
    )(request.buildAwsValue())
      .map(item => zio.aws.iotfleetwise.model.SignalDecoder.wrap(item))
      .provideEnvironment(r)
    def listDecoderManifestSignalsPaginated(
        request: ListDecoderManifestSignalsRequest
    ): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest,
      ListDecoderManifestSignalsResponse
    ]("listDecoderManifestSignals", api.listDecoderManifestSignals)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateVehicle(request: BatchUpdateVehicleRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest,
      BatchUpdateVehicleResponse
    ]("batchUpdateVehicle", api.batchUpdateVehicle)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.wrap)
      .provideEnvironment(r)
    def associateVehicleFleet(request: AssociateVehicleFleetRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.AssociateVehicleFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.AssociateVehicleFleetRequest,
      AssociateVehicleFleetResponse
    ]("associateVehicleFleet", api.associateVehicleFleet)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.AssociateVehicleFleetResponse.wrap)
      .provideEnvironment(r)
    def createCampaign(request: CreateCampaignRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.CreateCampaignRequest,
      CreateCampaignResponse
    ]("createCampaign", api.createCampaign)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.CreateCampaignResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.iotfleetwise.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.iotfleetwise.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.iotfleetwise.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getVehicleStatus(request: GetVehicleStatusRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest,
      VehicleStatus,
      GetVehicleStatusPublisher
    ]("getVehicleStatus", api.getVehicleStatusPaginator, _.campaigns())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.VehicleStatus.wrap(item))
      .provideEnvironment(r)
    def getVehicleStatusPaginated(request: GetVehicleStatusRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest,
      GetVehicleStatusResponse
    ]("getVehicleStatus", api.getVehicleStatus)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.GetVehicleStatusResponse.wrap)
      .provideEnvironment(r)
    def listSignalCatalogs(request: ListSignalCatalogsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest,
      SignalCatalogSummary,
      ListSignalCatalogsPublisher
    ]("listSignalCatalogs", api.listSignalCatalogsPaginator, _.summaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.SignalCatalogSummary.wrap(item))
      .provideEnvironment(r)
    def listSignalCatalogsPaginated(request: ListSignalCatalogsRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest,
      ListSignalCatalogsResponse
    ]("listSignalCatalogs", api.listSignalCatalogs)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.wrap)
      .provideEnvironment(r)
    def listModelManifestNodes(
        request: ListModelManifestNodesRequest
    ): ZStream[Any, AwsError, zio.aws.iotfleetwise.model.Node.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest,
        Node,
        ListModelManifestNodesPublisher
      ](
        "listModelManifestNodes",
        api.listModelManifestNodesPaginator,
        _.nodes()
      )(request.buildAwsValue())
        .map(item => zio.aws.iotfleetwise.model.Node.wrap(item))
        .provideEnvironment(r)
    def listModelManifestNodesPaginated(
        request: ListModelManifestNodesRequest
    ): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest,
      ListModelManifestNodesResponse
    ]("listModelManifestNodes", api.listModelManifestNodes)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.wrap)
      .provideEnvironment(r)
    def createSignalCatalog(request: CreateSignalCatalogRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.CreateSignalCatalogResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.CreateSignalCatalogRequest,
      CreateSignalCatalogResponse
    ]("createSignalCatalog", api.createSignalCatalog)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.CreateSignalCatalogResponse.wrap)
      .provideEnvironment(r)
    def batchCreateVehicle(request: BatchCreateVehicleRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleRequest,
      BatchCreateVehicleResponse
    ]("batchCreateVehicle", api.batchCreateVehicle)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.wrap)
      .provideEnvironment(r)
    def getLoggingOptions(request: GetLoggingOptionsRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.GetLoggingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.GetLoggingOptionsRequest,
      GetLoggingOptionsResponse
    ]("getLoggingOptions", api.getLoggingOptions)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.GetLoggingOptionsResponse.wrap)
      .provideEnvironment(r)
    def updateDecoderManifest(request: UpdateDecoderManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.UpdateDecoderManifestRequest,
      UpdateDecoderManifestResponse
    ]("updateDecoderManifest", api.updateDecoderManifest)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.wrap)
      .provideEnvironment(r)
    def createDecoderManifest(request: CreateDecoderManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.CreateDecoderManifestRequest,
      CreateDecoderManifestResponse
    ]("createDecoderManifest", api.createDecoderManifest)(
      request.buildAwsValue()
    ).map(zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.wrap)
      .provideEnvironment(r)
    def listVehiclesInFleet(
        request: ListVehiclesInFleetRequest
    ): ZStream[Any, AwsError, VehicleName] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest,
      java.lang.String,
      ListVehiclesInFleetPublisher
    ]("listVehiclesInFleet", api.listVehiclesInFleetPaginator, _.vehicles())(
      request.buildAwsValue()
    ).map(item => zio.aws.iotfleetwise.model.primitives.VehicleName(item))
      .provideEnvironment(r)
    def listVehiclesInFleetPaginated(request: ListVehiclesInFleetRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest,
      ListVehiclesInFleetResponse
    ]("listVehiclesInFleet", api.listVehiclesInFleet)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.wrap)
      .provideEnvironment(r)
    def updateModelManifest(request: UpdateModelManifestRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.UpdateModelManifestResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.UpdateModelManifestRequest,
      UpdateModelManifestResponse
    ]("updateModelManifest", api.updateModelManifest)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.UpdateModelManifestResponse.wrap)
      .provideEnvironment(r)
    def updateCampaign(request: UpdateCampaignRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.UpdateCampaignRequest,
      UpdateCampaignResponse
    ]("updateCampaign", api.updateCampaign)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.UpdateCampaignResponse.wrap)
      .provideEnvironment(r)
    def getSignalCatalog(request: GetSignalCatalogRequest): IO[
      AwsError,
      zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogRequest,
      GetSignalCatalogResponse
    ]("getSignalCatalog", api.getSignalCatalog)(request.buildAwsValue())
      .map(zio.aws.iotfleetwise.model.GetSignalCatalogResponse.wrap)
      .provideEnvironment(r)
  }
  def listDecoderManifestNetworkInterfaces(
      request: ListDecoderManifestNetworkInterfacesRequest
  ): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
  ] = ZStream.serviceWithStream(_.listDecoderManifestNetworkInterfaces(request))
  def listDecoderManifestNetworkInterfacesPaginated(
      request: ListDecoderManifestNetworkInterfacesRequest
  ): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listDecoderManifestNetworkInterfacesPaginated(request))
  def getDecoderManifest(request: GetDecoderManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDecoderManifest(request))
  def deleteCampaign(request: DeleteCampaignRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DeleteCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCampaign(request))
  def getCampaign(request: GetCampaignRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCampaign(request))
  def updateVehicle(request: UpdateVehicleRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.UpdateVehicleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVehicle(request))
  def deleteModelManifest(request: DeleteModelManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteModelManifest(request))
  def listCampaigns(request: ListCampaignsRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCampaigns(request))
  def listCampaignsPaginated(request: ListCampaignsRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCampaignsPaginated(request))
  def registerAccount(request: RegisterAccountRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerAccount(request))
  def deleteVehicle(request: DeleteVehicleRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVehicle(request))
  def deleteDecoderManifest(request: DeleteDecoderManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DeleteDecoderManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDecoderManifest(request))
  def importSignalCatalog(request: ImportSignalCatalogRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ImportSignalCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importSignalCatalog(request))
  def listFleetsForVehicle(
      request: ListFleetsForVehicleRequest
  ): ZStream[zio.aws.iotfleetwise.IoTFleetWise, AwsError, FleetId] =
    ZStream.serviceWithStream(_.listFleetsForVehicle(request))
  def listFleetsForVehiclePaginated(request: ListFleetsForVehicleRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFleetsForVehiclePaginated(request))
  def disassociateVehicleFleet(request: DisassociateVehicleFleetRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DisassociateVehicleFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateVehicleFleet(request))
  def listFleets(request: ListFleetsRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.FleetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listFleets(request))
  def listFleetsPaginated(request: ListFleetsRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFleetsPaginated(request))
  def listSignalCatalogNodes(request: ListSignalCatalogNodesRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.Node.ReadOnly
  ] = ZStream.serviceWithStream(_.listSignalCatalogNodes(request))
  def listSignalCatalogNodesPaginated(
      request: ListSignalCatalogNodesRequest
  ): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListSignalCatalogNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSignalCatalogNodesPaginated(request))
  def importDecoderManifest(request: ImportDecoderManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ImportDecoderManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importDecoderManifest(request))
  def createVehicle(request: CreateVehicleRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.CreateVehicleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVehicle(request))
  def updateSignalCatalog(
      request: UpdateSignalCatalogRequest
  ): ZIO[zio.aws.iotfleetwise.IoTFleetWise, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateSignalCatalog(request))
  def listModelManifests(request: ListModelManifestsRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelManifests(request))
  def listModelManifestsPaginated(request: ListModelManifestsRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelManifestsPaginated(request))
  def deleteFleet(request: DeleteFleetRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFleet(request))
  def putLoggingOptions(request: PutLoggingOptionsRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.PutLoggingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putLoggingOptions(request))
  def listVehicles(request: ListVehiclesRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listVehicles(request))
  def listVehiclesPaginated(request: ListVehiclesRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVehiclesPaginated(request))
  def updateFleet(request: UpdateFleetRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFleet(request))
  def createModelManifest(request: CreateModelManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelManifest(request))
  def listDecoderManifests(request: ListDecoderManifestsRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDecoderManifests(request))
  def listDecoderManifestsPaginated(request: ListDecoderManifestsRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDecoderManifestsPaginated(request))
  def getFleet(request: GetFleetRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFleet(request))
  def deleteSignalCatalog(request: DeleteSignalCatalogRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSignalCatalog(request))
  def getModelManifest(request: GetModelManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetModelManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelManifest(request))
  def createFleet(request: CreateFleetRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleet(request))
  def getVehicle(request: GetVehicleRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVehicle(request))
  def getRegisterAccountStatus(request: GetRegisterAccountStatusRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRegisterAccountStatus(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listDecoderManifestSignals(
      request: ListDecoderManifestSignalsRequest
  ): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
  ] = ZStream.serviceWithStream(_.listDecoderManifestSignals(request))
  def listDecoderManifestSignalsPaginated(
      request: ListDecoderManifestSignalsRequest
  ): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDecoderManifestSignalsPaginated(request))
  def batchUpdateVehicle(request: BatchUpdateVehicleRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateVehicle(request))
  def associateVehicleFleet(request: AssociateVehicleFleetRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.AssociateVehicleFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateVehicleFleet(request))
  def createCampaign(request: CreateCampaignRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCampaign(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getVehicleStatus(request: GetVehicleStatusRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.getVehicleStatus(request))
  def getVehicleStatusPaginated(request: GetVehicleStatusRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVehicleStatusPaginated(request))
  def listSignalCatalogs(request: ListSignalCatalogsRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSignalCatalogs(request))
  def listSignalCatalogsPaginated(request: ListSignalCatalogsRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSignalCatalogsPaginated(request))
  def listModelManifestNodes(request: ListModelManifestNodesRequest): ZStream[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.Node.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelManifestNodes(request))
  def listModelManifestNodesPaginated(
      request: ListModelManifestNodesRequest
  ): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelManifestNodesPaginated(request))
  def createSignalCatalog(request: CreateSignalCatalogRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.CreateSignalCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSignalCatalog(request))
  def batchCreateVehicle(request: BatchCreateVehicleRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateVehicle(request))
  def getLoggingOptions(request: GetLoggingOptionsRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetLoggingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoggingOptions(request))
  def updateDecoderManifest(request: UpdateDecoderManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDecoderManifest(request))
  def createDecoderManifest(request: CreateDecoderManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDecoderManifest(request))
  def listVehiclesInFleet(
      request: ListVehiclesInFleetRequest
  ): ZStream[zio.aws.iotfleetwise.IoTFleetWise, AwsError, VehicleName] =
    ZStream.serviceWithStream(_.listVehiclesInFleet(request))
  def listVehiclesInFleetPaginated(request: ListVehiclesInFleetRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVehiclesInFleetPaginated(request))
  def updateModelManifest(request: UpdateModelManifestRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.UpdateModelManifestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateModelManifest(request))
  def updateCampaign(request: UpdateCampaignRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCampaign(request))
  def getSignalCatalog(request: GetSignalCatalogRequest): ZIO[
    zio.aws.iotfleetwise.IoTFleetWise,
    AwsError,
    zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSignalCatalog(request))
}
