package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{CanSignalName, NonNegativeInteger}
import scala.jdk.CollectionConverters._
final case class CanSignal(
    messageId: NonNegativeInteger,
    isBigEndian: Boolean,
    isSigned: Boolean,
    startBit: NonNegativeInteger,
    offset: Double,
    factor: Double,
    length: NonNegativeInteger,
    name: Optional[CanSignalName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CanSignal = {
    import CanSignal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CanSignal
      .builder()
      .messageId(NonNegativeInteger.unwrap(messageId): Integer)
      .isBigEndian(isBigEndian: java.lang.Boolean)
      .isSigned(isSigned: java.lang.Boolean)
      .startBit(NonNegativeInteger.unwrap(startBit): Integer)
      .offset(offset: java.lang.Double)
      .factor(factor: java.lang.Double)
      .length(NonNegativeInteger.unwrap(length): Integer)
      .optionallyWith(
        name.map(value => CanSignalName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CanSignal.ReadOnly =
    zio.aws.iotfleetwise.model.CanSignal.wrap(buildAwsValue())
}
object CanSignal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CanSignal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CanSignal =
      zio.aws.iotfleetwise.model.CanSignal(
        messageId,
        isBigEndian,
        isSigned,
        startBit,
        offset,
        factor,
        length,
        name.map(value => value)
      )
    def messageId: NonNegativeInteger
    def isBigEndian: Boolean
    def isSigned: Boolean
    def startBit: NonNegativeInteger
    def offset: Double
    def factor: Double
    def length: NonNegativeInteger
    def name: Optional[CanSignalName]
    def getMessageId: ZIO[Any, Nothing, NonNegativeInteger] =
      ZIO.succeed(messageId)
    def getIsBigEndian: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isBigEndian)
    def getIsSigned: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isSigned)
    def getStartBit: ZIO[Any, Nothing, NonNegativeInteger] =
      ZIO.succeed(startBit)
    def getOffset: ZIO[Any, Nothing, Double] = ZIO.succeed(offset)
    def getFactor: ZIO[Any, Nothing, Double] = ZIO.succeed(factor)
    def getLength: ZIO[Any, Nothing, NonNegativeInteger] = ZIO.succeed(length)
    def getName: ZIO[Any, AwsError, CanSignalName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CanSignal
  ) extends zio.aws.iotfleetwise.model.CanSignal.ReadOnly {
    override val messageId: NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(impl.messageId())
    override val isBigEndian: Boolean = impl.isBigEndian(): Boolean
    override val isSigned: Boolean = impl.isSigned(): Boolean
    override val startBit: NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(impl.startBit())
    override val offset: Double = impl.offset(): Double
    override val factor: Double = impl.factor(): Double
    override val length: NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(impl.length())
    override val name: Optional[CanSignalName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotfleetwise.model.primitives.CanSignalName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CanSignal
  ): zio.aws.iotfleetwise.model.CanSignal.ReadOnly = new Wrapper(impl)
}
