package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListModelManifestsResponse(
    summaries: Optional[
      Iterable[zio.aws.iotfleetwise.model.ModelManifestSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse = {
    import ListModelManifestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListModelManifestsResponse.wrap(buildAwsValue())
}
object ListModelManifestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListModelManifestsResponse =
      zio.aws.iotfleetwise.model.ListModelManifestsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Optional[
      List[zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse
  ) extends zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly {
    override val summaries: Optional[
      List[zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.ModelManifestSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse
  ): zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly =
    new Wrapper(impl)
}
