package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, Description, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelManifestRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    nodes: Iterable[String],
    signalCatalogArn: Arn,
    tags: Optional[Iterable[zio.aws.iotfleetwise.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest = {
    import CreateModelManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .nodes(nodes.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .signalCatalogArn(Arn.unwrap(signalCatalogArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.CreateModelManifestRequest.ReadOnly =
    zio.aws.iotfleetwise.model.CreateModelManifestRequest.wrap(buildAwsValue())
}
object CreateModelManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateModelManifestRequest =
      zio.aws.iotfleetwise.model.CreateModelManifestRequest(
        name,
        description.map(value => value),
        nodes,
        signalCatalogArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResourceName
    def description: Optional[Description]
    def nodes: List[String]
    def signalCatalogArn: Arn
    def tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNodes: ZIO[Any, Nothing, List[String]] = ZIO.succeed(nodes)
    def getSignalCatalogArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(signalCatalogArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest
  ) extends zio.aws.iotfleetwise.model.CreateModelManifestRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val nodes: List[String] = impl
      .nodes()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val signalCatalogArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.signalCatalogArn())
    override val tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateModelManifestRequest
  ): zio.aws.iotfleetwise.model.CreateModelManifestRequest.ReadOnly =
    new Wrapper(impl)
}
