package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters._
sealed trait LogType {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.LogType
}
object LogType {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.LogType
  ): zio.aws.iotfleetwise.model.LogType = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.LogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.LogType.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.iotfleetwise.model.LogType.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.iotfleetwise.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.LogType =
      software.amazon.awssdk.services.iotfleetwise.model.LogType.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.iotfleetwise.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.LogType =
      software.amazon.awssdk.services.iotfleetwise.model.LogType.OFF
  }
  case object ERROR extends zio.aws.iotfleetwise.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.LogType =
      software.amazon.awssdk.services.iotfleetwise.model.LogType.ERROR
  }
}
