package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{MaxResults, NextToken, FleetId}
import scala.jdk.CollectionConverters._
final case class ListVehiclesInFleetRequest(
    fleetId: FleetId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest = {
    import ListVehiclesInFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListVehiclesInFleetRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ListVehiclesInFleetRequest.wrap(buildAwsValue())
}
object ListVehiclesInFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListVehiclesInFleetRequest =
      zio.aws.iotfleetwise.model.ListVehiclesInFleetRequest(
        fleetId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def fleetId: FleetId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest
  ) extends zio.aws.iotfleetwise.model.ListVehiclesInFleetRequest.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.fleetId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotfleetwise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest
  ): zio.aws.iotfleetwise.model.ListVehiclesInFleetRequest.ReadOnly =
    new Wrapper(impl)
}
