package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  NodePath,
  Description,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSignalCatalogRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    nodesToAdd: Optional[Iterable[zio.aws.iotfleetwise.model.Node]] =
      Optional.Absent,
    nodesToUpdate: Optional[Iterable[zio.aws.iotfleetwise.model.Node]] =
      Optional.Absent,
    nodesToRemove: Optional[Iterable[NodePath]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest = {
    import UpdateSignalCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        nodesToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodesToAdd)
      .optionallyWith(
        nodesToUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodesToUpdate)
      .optionallyWith(
        nodesToRemove.map(value =>
          value.map { item =>
            NodePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nodesToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.UpdateSignalCatalogRequest.ReadOnly =
    zio.aws.iotfleetwise.model.UpdateSignalCatalogRequest.wrap(buildAwsValue())
}
object UpdateSignalCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.UpdateSignalCatalogRequest =
      zio.aws.iotfleetwise.model.UpdateSignalCatalogRequest(
        name,
        description.map(value => value),
        nodesToAdd.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nodesToUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nodesToRemove.map(value => value)
      )
    def name: ResourceName
    def description: Optional[Description]
    def nodesToAdd: Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]]
    def nodesToUpdate: Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]]
    def nodesToRemove: Optional[List[NodePath]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNodesToAdd
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodesToAdd", nodesToAdd)
    def getNodesToUpdate
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      AwsError.unwrapOptionField("nodesToUpdate", nodesToUpdate)
    def getNodesToRemove: ZIO[Any, AwsError, List[NodePath]] =
      AwsError.unwrapOptionField("nodesToRemove", nodesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest
  ) extends zio.aws.iotfleetwise.model.UpdateSignalCatalogRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val nodesToAdd
        : Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Node.wrap(item)
          }.toList
        )
    override val nodesToUpdate
        : Optional[List[zio.aws.iotfleetwise.model.Node.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodesToUpdate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Node.wrap(item)
          }.toList
        )
    override val nodesToRemove: Optional[List[NodePath]] = zio.aws.core.internal
      .optionalFromNullable(impl.nodesToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.primitives.NodePath(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.UpdateSignalCatalogRequest
  ): zio.aws.iotfleetwise.model.UpdateSignalCatalogRequest.ReadOnly =
    new Wrapper(impl)
}
